﻿'由于加载的是频道图像，因此需要 System.IO。
Imports System.IO

'需要 Imaging 以采用手动方式循环通过动画 .gif 的帧
Imports System.Drawing.Imaging

''' <summary>
'''VCR 示例应用程序的
'''主窗体。使用
'''Visual Basic 对象模拟录像机。
''' </summary>
''' <remarks></remarks>
Public Class VCRScreen

    Private Enum PlayState
        Record
        Play
        FastForward
        Rewind
        Pause
        Stopped
        TV
    End Enum

    '在记录时或频道已更改时进行跟踪，以便在
    '窗体失去并重新获得焦点后在 PictureBox 中重新绘制信息。
    Private playingState As PlayState = PlayState.TV
    Private isChannelChanged As Boolean = True
    Private channels As New System.Collections.Generic.Dictionary(Of Integer, Channel)

    Dim channelBitmap As Image
    Dim currentFrame As New Hashtable()
    Dim currentFrameCount As Integer
    Dim lastChannelLoaded As Integer
    Dim tvChannel As Channel

    Dim recorder As New Recorder
    '可以控制动画 gif 图像的帧速率。
    'channelRate 是每个频道各个帧之间的毫秒数。
    Dim channelRate() As Integer = {0, 0, 1400, 1400, 1400, 1400}

    'Tape 类记录屏幕上的内容。
    Dim tape As New Tape()

    'Dim currentChannel As Integer = 3

#Region "频道递增和递减"
    Private Sub cmdDown_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdDown.Click
        '有效范围为 2 至 5。
        If tvChannel.Number = 2 Then
            tvChannel = channels(5)
        Else
            tvChannel = channels(tvChannel.Number - 1)
        End If

        '将频道变量分配给显示器
        lblChannel.Text = CStr(tvChannel.Number)
        channelBitmap = tvChannel.Image

        '设置频道更改标志。
        isChannelChanged = True

    End Sub

    Private Sub cmdUp_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdUp.Click
        '有效范围为 2 至 5。
        If tvChannel.Number = 5 Then
            tvChannel = channels(2)
        Else
            tvChannel = channels(tvChannel.Number + 1)
        End If

        '将频道变量分配给显示器
        lblChannel.Text = CStr(tvChannel.Number)
        channelBitmap = tvChannel.Image

        '设置频道更改标志。
        isChannelChanged = True
    End Sub
#End Region

#Region "加载和退出"
    Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
        Me.Close()
    End Sub

    Private Sub frmVCR_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        '加载频道。
        Dim fullpath As String = Path.GetFullPath(Application.StartupPath & "\..\..\images\")
        Dim imageFile As String = ""
        Dim newChannel As Channel
        For index As Integer = 2 To 5
            imageFile = fullpath & "Channel_" & index & ".gif"
            newChannel = New Channel(index, channelRate(index), imageFile)
            channels.Add(index, newChannel)
        Next

        tvChannel = channels(2)
        channelBitmap = tvChannel.Image

        '显示当前时间
        lblTime.Text = Format(Now, "h:mm tt")
        lblChannel.Text = CStr(tvChannel.Number)

        Me.ButtonManager(PlayState.TV)
    End Sub
#End Region

#Region "VCR - 播放、倒带、快进、记录、暂停、停止"
    Private Sub cmdForward_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdForward.Click
        '必须在信道 3 才能播放磁带
        tvChannel = channels(3)
        isChannelChanged = True

        lblChannel.Text = CStr(tvChannel.Number)

        ButtonManager(PlayState.FastForward)
        isChannelChanged = False
        playingState = PlayState.FastForward
    End Sub


    Private Sub cmdPause_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPause.Click
        '调用更新控件的函数
        ButtonManager(PlayState.Pause)
        isChannelChanged = False
        playingState = PlayState.Pause
    End Sub

    Private Sub cmdPlay_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPlay.Click
        '必须在信道 3 才能播放磁带
        tvChannel = channels(3)
        lblChannel.Text = CStr(tvChannel.Number)

        '调用更新控件的函数
        ButtonManager(PlayState.Play)
        isChannelChanged = False
        playingState = PlayState.Play
    End Sub

    Private Sub cmdRec_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdRec.Click
        '调用更新控件的函数
        ButtonManager(PlayState.Record)

        '设置记录和信道更改标志。显示记录状态。
        playingState = PlayState.Record
    End Sub

    Private Sub cmdRewind_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdRewind.Click
        '必须在信道 3 才能播放磁带
        tvChannel = channels(3)

        lblChannel.Text = CStr(tvChannel.Number)

        '调用更新控件的函数
        ButtonManager(PlayState.Rewind)
        isChannelChanged = False
        playingState = PlayState.Rewind
    End Sub

    Private Sub cmdStop_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdStop.Click
        '调用更新控件的函数
        ButtonManager(PlayState.Stopped)

        lblChannel.Text = CStr(tvChannel.Number)

        If playingState = PlayState.Record Then
            If MessageBox.Show("Would you like to rewind the tape at this time?", _
                "Rewind?", MessageBoxButtons.YesNo) = Windows.Forms.DialogResult.Yes Then
                tape.Rewind()
            End If
        End If

        '设置记录标志。
        isChannelChanged = True
        playingState = PlayState.TV
    End Sub

#End Region

#Region "设置记录次数"
    Private Sub cmdSet_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSet.Click
        '模式显示用户项目表单
        Dim frm As New SetRecording()
        frm.ShowDialog()
    End Sub
#End Region

#Region "显示动画信道"
    Private Sub tmr1_Tick(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles tmr1.Tick
        '更新时间显示
        lblTime.Text = Format(Now, "h:mm tt")

        '如果 Recorder 属性打开
        If recorder.Enabled = True Then
            '如果是时候记录了
            If recorder.StartTime.Hour = Now.Hour And recorder.StartTime.Minute = Now.Minute Then
                '开始“记录”
                tvChannel = channels(recorder.Channel)
                isChannelChanged = True

                lblChannel.Text = CStr(tvChannel.Number)

                '激活“记录”按钮
                cmdRec_Click(cmdRec, New System.EventArgs())
            End If
        Else
            '如果是时候停止记录了
            If recorder.StopTime.Hour = Now.Hour And recorder.StopTime.Minute = Now.Minute Then
                '激活“停止”按钮
                playingState = PlayState.Stopped
                cmdStop_Click(cmdStop, New System.EventArgs())

                '清除 Recorder 类中的属性
                recorder.IsSet = False
            End If
        End If
    End Sub

    Private Sub DisplayInfo()
        Static tf As TapeFrame

        '如果信道已更改，则更改计时器间隔。
        If isChannelChanged Then
            frameTimer.Interval = tvChannel.RefreshRate
            isChannelChanged = False
        End If

        '如果播放或快进，则数据来自 tape 类。
        Select Case playingState
            Case PlayState.FastForward
                tf = tape.GetNextFrame()
                frameTimer.Interval = channels(tf.ChannelNumber).RefreshRate
                '快进 - 以 10x 速度浏览磁带。
                frameTimer.Interval = frameTimer.Interval \ 10
                DrawChannel(tf.ChannelNumber, tf.Frame)

            Case PlayState.Pause
                frameTimer.Interval = channels(tf.ChannelNumber).RefreshRate
                DrawChannel(tf.ChannelNumber, tf.Frame)

            Case PlayState.Play
                tf = tape.GetNextFrame()
                frameTimer.Interval = channels(tf.ChannelNumber).RefreshRate
                DrawChannel(tf.ChannelNumber, tf.Frame)

            Case PlayState.Record
                '循环图像并记录它们。
                If tvChannel.CurrentFrame = tvChannel.FrameCount - 1 Then
                    tvChannel.CurrentFrame = 0
                Else
                    tvChannel.CurrentFrame += 1
                End If
                DrawChannel(tvChannel.Number, tvChannel.CurrentFrame)
                tape.SaveFrame(tvChannel.Number, tvChannel.CurrentFrame)

            Case PlayState.Rewind
                '倒带工作方式和播放和快进类似。
                tf = tape.GetPreviousFrame()
                frameTimer.Interval = channels(tf.ChannelNumber).RefreshRate \ 10
                DrawChannel(tf.ChannelNumber, tf.Frame)

            Case PlayState.Stopped
            Case PlayState.TV
                '循环图像。
                If tvChannel.CurrentFrame = tvChannel.FrameCount - 1 Then
                    tvChannel.CurrentFrame = 0
                Else
                    tvChannel.CurrentFrame += 1
                End If
                DrawChannel(tvChannel.Number, tvChannel.CurrentFrame)

        End Select
    End Sub

    ''' <summary>
    '''frameTimer 控制电视上显示的内容。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub frameTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles frameTimer.Tick
        DisplayInfo()
    End Sub


    ''' <summary>
    '''绘制实际图像帧。
    ''' </summary>
    ''' <param name="frame"></param>
    ''' <remarks></remarks>
    Private Sub DrawChannel(ByVal channelnumber As Integer, ByVal frame As Integer)
        channelBitmap = channels(channelnumber).Image
        Dim frameDim As New FrameDimension(channels(channelnumber).Image.FrameDimensionsList(0))
        channelBitmap.SelectActiveFrame(frameDim, frame)
        'Dim fd As New FrameDimension(channelBitmap.FrameDimensionsList(0))
        'channelBitmap.SelectActiveFrame(fd, frame)

        Dim g As Graphics = picTV.CreateGraphics
        g.DrawImage(channelBitmap, New Point(0, 0))

        Dim sans18 As New Font("Microsoft Sans Serif", 18)
        '如果记录，则在左上部写入记录
        '消息。以黑白偏移写入，这样文本将
        '可见，无论背景是什么颜色。
        If playingState = PlayState.Record Then
            g.DrawString("Recording: Channel " & channelnumber, sans18, Brushes.Black, 0, 0)
            g.DrawString(lblTime.Text, sans18, Brushes.Black, 0, 25)
            g.DrawString("Recording: Channel " & channelnumber, sans18, Brushes.White, 1, 1)
            g.DrawString(lblTime.Text, sans18, Brushes.White, 1, 26)
            If playingState <> PlayState.Pause Then
                tape.SaveFrame(channelnumber, CInt(currentFrame(channelnumber)))
            End If
            g.Dispose()
        End If
    End Sub
#End Region

#Region "UI 更新"
    ''' <summary>
    '''根据当前模式启用或禁用 VCR 窗体上的按钮。
    ''' </summary>
    ''' <param name="playingState">要采取的操作。</param>
    ''' <remarks></remarks>
    Private Sub ButtonManager(ByVal playingState As PlayState)
        '确定按下哪个功能按钮
        '并更新所有按钮和 Recorder 类。
        Me.cmdPause.Enabled = False
        Me.cmdStop.Enabled = False
        Me.cmdPlay.Enabled = False
        Me.cmdForward.Enabled = False
        Me.cmdRewind.Enabled = False
        Me.cmdDown.Enabled = False
        Me.cmdUp.Enabled = False

        Select Case playingState
            Case PlayState.Play, PlayState.FastForward, PlayState.Rewind
                Me.cmdPause.Enabled = True
                Me.cmdStop.Enabled = True

            Case PlayState.Record
                'Me.cmdPause.Enabled = True
                Me.cmdStop.Enabled = True

            Case PlayState.Pause
                Me.cmdPlay.Enabled = True

            Case PlayState.Stopped
                Me.cmdRec.Enabled = True
                Me.cmdPlay.Enabled = True
                Me.cmdForward.Enabled = True
                Me.cmdRewind.Enabled = True
                Me.cmdDown.Enabled = True
                Me.cmdUp.Enabled = True
                recorder.Enabled = True

            Case PlayState.TV
                Me.cmdUp.Enabled = True
                Me.cmdDown.Enabled = True

        End Select
    End Sub
#End Region

End Class